/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.holo;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class ScanHelper {
    public static boolean hasStructure(String id, ServerLevel level, ChunkPos chunkPos) {
        Registry registry = level.m_5962_().m_175515_(Registry.f_235725_);
        HolderSet.ListBacked<Structure> holders = ScanHelper.getHolders(ScanHelper.getKey(id), (Registry<Structure>)registry).get();
        return !ScanHelper.hasStructure(holders, (LevelReader)level, level.m_215010_(), false, chunkPos).isEmpty();
    }

    private static Set<Holder<Structure>> hasStructure(HolderSet.ListBacked<Structure> holders, LevelReader level, StructureManager structureManager, boolean skipGenerated, ChunkPos chunkPos) {
        return holders.m_203614_().filter(holder -> ScanHelper.hasStructure((Holder<Structure>)holder, level, structureManager, skipGenerated, chunkPos)).collect(Collectors.toUnmodifiableSet());
    }

    private static boolean hasStructure(Holder<Structure> holder, LevelReader level, StructureManager structureManager, boolean skipGenerated, ChunkPos chunkPos) {
        StructureCheckResult result = structureManager.m_220473_(chunkPos, (Structure)holder.m_203334_(), skipGenerated);
        if (result != StructureCheckResult.START_NOT_PRESENT) {
            if (!skipGenerated && result == StructureCheckResult.START_PRESENT) {
                return true;
            }
            ChunkAccess chunk = level.m_46819_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62315_);
            StructureStart structurestart = structureManager.m_220512_(SectionPos.m_175562_((ChunkAccess)chunk), (Structure)holder.m_203334_(), (StructureAccess)chunk);
            if (structurestart != null && structurestart.m_73603_()) {
                return true;
            }
        }
        return false;
    }

    private static Either<ResourceKey<Structure>, TagKey<Structure>> getKey(String identifier) {
        if (identifier.startsWith("#")) {
            return Either.right((Object)TagKey.m_203882_((ResourceKey)Registry.f_235725_, (ResourceLocation)new ResourceLocation(identifier.substring(1))));
        }
        return Either.left((Object)ResourceKey.m_135785_((ResourceKey)Registry.f_235725_, (ResourceLocation)new ResourceLocation(identifier)));
    }

    private static Optional<? extends HolderSet.ListBacked<Structure>> getHolders(Either<ResourceKey<Structure>, TagKey<Structure>> key, Registry<Structure> registry) {
        return (Optional)key.map(p_214494_ -> registry.m_203636_(p_214494_).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0})), arg_0 -> registry.m_203431_(arg_0));
    }
}

